/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.audio.aiff;

import org.jaudiotagger.audio.aiff.AiffTagFieldKey;
import org.jaudiotagger.audio.generic.GenericTag;
import org.jaudiotagger.audio.generic.Utils;
import org.jaudiotagger.tag.FieldDataInvalidException;
import org.jaudiotagger.tag.FieldKey;
import org.jaudiotagger.tag.KeyNotFoundException;
import org.jaudiotagger.tag.TagField;
import org.jaudiotagger.tag.TagTextField;

public class AiffTag
extends GenericTag {
    public boolean hasField(AiffTagFieldKey fieldKey) {
        return this.hasField(fieldKey.name());
    }

    public void setField(AiffTagFieldKey genericKey, String value) throws KeyNotFoundException, FieldDataInvalidException {
        TagField tagfield = this.createField(genericKey, value);
        this.setField(tagfield);
    }

    public TagField createField(AiffTagFieldKey genericKey, String value) throws KeyNotFoundException, FieldDataInvalidException {
        return new AiffTagTextField(genericKey.name(), value);
    }

    @Override
    public TagField createCompilationField(boolean value) throws KeyNotFoundException, FieldDataInvalidException {
        return this.createField(FieldKey.IS_COMPILATION, String.valueOf(value));
    }

    private class AiffTagTextField
    implements TagTextField {
        private String content;
        private final String id;

        public AiffTagTextField(String fieldId, String initialContent) {
            this.id = fieldId;
            this.content = initialContent;
        }

        @Override
        public void copyContent(TagField field) {
            if (field instanceof TagTextField) {
                this.content = ((TagTextField)field).getContent();
            }
        }

        @Override
        public String getContent() {
            return this.content;
        }

        @Override
        public String getEncoding() {
            return "ISO-8859-1";
        }

        @Override
        public String getId() {
            return this.id;
        }

        @Override
        public byte[] getRawContent() {
            return this.content == null ? new byte[]{} : Utils.getDefaultBytes(this.content, this.getEncoding());
        }

        @Override
        public boolean isBinary() {
            return false;
        }

        @Override
        public void isBinary(boolean b) {
        }

        @Override
        public boolean isCommon() {
            return true;
        }

        @Override
        public boolean isEmpty() {
            return this.content.equals("");
        }

        @Override
        public void setContent(String s) {
            this.content = s;
        }

        @Override
        public void setEncoding(String s) {
        }

        @Override
        public String toString() {
            return this.getContent();
        }
    }
}

